----------------------------------------------------------------------------------
-- Company    : hdLab
-- Engineer   : 
-- 
-- Create Date:    2016/01/31
-- Design Name:    ARTY_TOP
-- Module Name:    ARTY_TOP 
-- Project Name:   Artix-7 ARTY
-- Target Devices: Artix-7
-- Tool versions:  Vivado2015.4
-- Description:    
--
-- Dependencies: 
--
-- Revision: 
-- Revision 1.00 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity ARTY_TOP is
    port (
        CLKIN		: in  STD_LOGIC;
        USER_RSTn	: in  STD_LOGIC;
        BTN			: in  STD_LOGIC_VECTOR(3 downto 0);
        SW			: in  STD_LOGIC_VECTOR(3 downto 0);
        RXD			: in  STD_LOGIC;
        TXD			: out  STD_LOGIC;
        LD0_Red		: out  STD_LOGIC;
        LD0_Green	: out  STD_LOGIC;
        LD0_Blue	: out  STD_LOGIC;
        LD1_Red		: out  STD_LOGIC;
        LD1_Green	: out  STD_LOGIC;
        LD1_Blue	: out  STD_LOGIC;
        LD2_Red		: out  STD_LOGIC;
        LD2_Green	: out  STD_LOGIC;
        LD2_Blue	: out  STD_LOGIC;
        LD3_Red		: out  STD_LOGIC;
        LD3_Green	: out  STD_LOGIC;
        LD3_Blue	: out  STD_LOGIC;
        LD4			: out  STD_LOGIC;
        LD5			: out  STD_LOGIC;
        LD6			: out  STD_LOGIC;
        LD7			: out  STD_LOGIC
    );
end ARTY_TOP;

architecture Behavioral of ARTY_TOP is

-- Compnent PLL_Block---@














-------------------

	component Uart_TX
	port(
		RESET : IN std_logic;
		CLK   : IN std_logic;          
		UART_TXD : OUT std_logic
		);
	end component;

	component uart_RX_count
	port(
		CLK   : IN std_logic;
		RESET : IN std_logic;
		RXD   : IN std_logic;          
		DOUT1 : OUT std_logic_vector(4 downto 0);
		DOUT2 : OUT std_logic_vector(4 downto 0);
		DOUT3 : OUT std_logic_vector(4 downto 0);
		DOUT4 : OUT std_logic_vector(4 downto 0)
		);
	end component;
	
    component RGB_controller 
	port(
		GCLK	: in std_logic;
		BTN     : in std_logic_vector(3 downto 0);
		LED0_O	: out std_logic_vector(2 downto 0);
		LED1_O	: out std_logic_vector(2 downto 0);
		LED2_O	: out std_logic_vector(2 downto 0);
		LED3_O	: out std_logic_vector(2 downto 0)
	);
    end component;
	
    signal DOUT1,DOUT2,DOUT3,DOUT4:	std_logic_vector(4 downto 0);	 
    signal CLK :std_logic;
    signal RESET,TXD_D:std_logic;

    attribute keep : string;
    attribute keep of TXD_D: signal is "TRUE";

begin

	process (CLK) 
	begin
		if CLK='1' and CLK'event then
            RESET <= not USER_RSTn;
            TXD   <= TXD_D;
            LD4   <= DOUT1(0) or SW(0);
            LD5   <= DOUT1(1) or SW(1);
            LD6   <= DOUT1(2) or SW(2);
            LD7   <= DOUT1(3) or SW(3);
		end if;
	end process; 

--- U0  PLL_Block  Instance --@













------------------------------

	U1: UART_TX port map(
		RESET     => RESET,
		CLK       => CLK,
		UART_TXD  => TXD_D 
	);

	U2: UART_RX_count port map(
		CLK       => CLK,
		RESET     => RESET,
		RXD       => RXD,
		DOUT1     => DOUT1,
		DOUT2     => DOUT2,
		DOUT3     => DOUT3,
		DOUT4     => DOUT4 
	);

	U3: RGB_controller port map(
		GCLK      => CLK, 
		BTN       => BTN,
		LED0_O(0) => LD0_Green,
		LED0_O(1) => LD0_Blue,
		LED0_O(2) => LD0_Red,
		LED1_O(0) => LD1_Green,
		LED1_O(1) => LD1_Blue,
		LED1_O(2) => LD1_Red,
		LED2_O(0) => LD2_Green,
		LED2_O(1) => LD2_Blue,
		LED2_O(2) => LD2_Red,
		LED3_O(0) => LD3_Green, 
		LED3_O(1) => LD3_Blue,
		LED3_O(2) => LD3_Red
	);

end Behavioral;
