//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    meta_harden 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------
module meta_harden(
	input			clk_dst,
	input			rst_dst,
	input			signal_src,
	output	reg		signal_dst
	);

	reg        signal_meta;

	// behaviorally coded meta-hardener
	always @(posedge clk_dst) begin
			if (rst_dst == 1'b1) begin	// if reset is asserted
				signal_meta	<= 1'b0;	// clear the output of the first flip-flop
				signal_dst	<= 1'b0;	// clear the output of the second and final flip-flop
			end else begin	// do non-reset activities
				signal_meta	<= signal_src;	// capture the arriving signal - higher probability of being meta-stable
				signal_dst	<= signal_meta;	// resample the potentially meta-stable signal, lowering the probability of meta-stability
     		end
	end
endmodule
