library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

--The IEEE.std_logic_unsigned contains definitions that allow 
--std_logic_vector types to be used with the + operator to instantiate a 
--counter.
use IEEE.std_logic_unsigned.all;

entity Uart_TX is
  port (
    RESET : in  std_logic;
    CLK : in  std_logic;
    UART_TXD : out std_logic
  );
end Uart_TX;

architecture Behavioral of Uart_TX is

component Uart_TX_State
  port(
    CLK : IN std_logic;
    RESET : IN std_logic;
    uartRdy : IN std_logic;          
    uartSend : OUT std_logic;
    Rom_addr : OUT std_logic_vector(5 downto 0)
  );
end component;

component UART_TX_CTRL
  port(
    SEND : in std_logic;
    DATA : in std_logic_vector(7 downto 0);
    CLK : in std_logic;          
    READY : out std_logic;
    UART_TX : out std_logic
  );
end component;

--  code_rom Component ---
COMPONENT code_rom
  PORT (
    clka : IN STD_LOGIC;
    addra : IN STD_LOGIC_VECTOR(5 DOWNTO 0);
    douta : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)
  );
END COMPONENT;








---------------------

--UART_TX_CTRL control signals
signal uartRdy : std_logic;
signal uartSend : std_logic := '0';
signal uartData : std_logic_vector (7 downto 0):= "00000000";
signal uartTX : std_logic;
signal addra : std_logic_vector (5 downto 0):= "000000";

--Current uart state signal
attribute keep : string;
attribute keep of uartRdy: signal is "TRUE";
attribute keep of uartSend: signal is "TRUE";
attribute keep of uartData: signal is "TRUE";
attribute keep of uartTX: signal is "TRUE";

begin

U1: Uart_TX_State port map(
  CLK => CLK,
  RESET => RESET,
  uartSend => uartSend,
  uartRdy => uartRdy,
  Rom_addr => addra
);

--Component used to send a byte of data over a UART line.
U2: UART_TX_CTRL port map(
  SEND => uartSend,
  DATA => uartData,
  CLK => CLK,
  READY => uartRdy,
  UART_TX => uartTX 
);

-- U3   code_rom Instance ---
U3 : code_rom
  PORT MAP (
    clka => CLK,
    addra => addra,
    douta => uartData
  );








-------------------------

UART_TXD <= uartTX;

end Behavioral;
