--------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    09:33:24 01/28/2009 
-- Design Name: 
-- Module Name:    led_ctl - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;


entity led_ctl is
  port (
    rst_clk_rx : in std_logic; -- reset signal synchronized with clk_rx
    clk : in std_logic; -- operational clock
    rx_data : in std_logic_vector(7 downto 0); -- data received by uart_rx
    rx_data_rdy : in std_logic; -- active high signal when rx_data is valid
    DOUT1    : out std_logic_vector(4 downto 0);
    DOUT2    : out std_logic_vector(4 downto 0);
    DOUT3    : out std_logic_vector(4 downto 0);
    DOUT4    : out std_logic_vector(4 downto 0)
  );
end led_ctl;


architecture Behavioral of led_ctl is
signal last_rx_data_rdy : std_logic := 'U';       -- temporary storage for previous state of ready signal
signal char_data : std_logic_vector (7 downto 0); -- Captured character
signal DOUT1_temp,DOUT2_temp,DOUT3_temp,DOUT4_temp :  std_logic_vector(4 downto 0);
		
begin
    
process (clk) begin -- process only sensitive to clock
  if (clk'event and clk ='1') then               -- only on the rising edge of the clock (i.e. synchronous)
    if (rst_clk_rx = '1') then                   -- if the reset is active (sync reset)
      last_rx_data_rdy <= '0';
      char_data        <= (others=>'0');
    else                                        -- not a reset condition
      last_rx_data_rdy <= rx_data_rdy;          -- update the last state of the ready signal
                                                -- detect the rising edge of rx_data_rdy and capture new data
      if ((rx_data_rdy /= last_rx_data_rdy) and (rx_data_rdy = '1')) then  -- look for both a change in the ready signal and the new state to be high
        char_data <= rx_data;                   -- capture the new data
      end if;                                   -- end of rising edge of rx_data_rdy check
                                                -- Select which set of bits get put on the low numbered LEDs and which go on the high LED
    end if;                                     -- end of reset/normal operations
  end if;                                        -- end of synchronous events
end process ;

process(char_data) begin
  case char_data is
  when x"30" => DOUT1_temp <= "00000";
  when x"31" => DOUT1_temp <= "00001";
  when x"32" => DOUT1_temp <= "00010";
  when x"33" => DOUT1_temp <= "00011";
  when x"34" => DOUT1_temp <= "00100";
  when x"35" => DOUT1_temp <= "00101";
  when x"36" => DOUT1_temp <= "00110";
  when x"37" => DOUT1_temp <= "00111";
  when x"38" => DOUT1_temp <= "01000";
  when x"39" => DOUT1_temp <= "01001";
  when others => DOUT1_temp <= "10000";
  end case;
end process;

process (clk,rst_clk_rx) begin -- process only sensitive to clock
  if (rst_clk_rx = '1') then -- if the reset is active (sync reset)
    DOUT2_temp <= "10000";
    DOUT3_temp <= "10000";
    DOUT4_temp <= "10000";
  elsif (clk'event and clk ='1') then                     
    if ((rx_data_rdy /= last_rx_data_rdy) and (rx_data_rdy = '1')) then
      DOUT2_temp <= DOUT1_temp;
      DOUT3_temp <= DOUT2_temp;
      DOUT4_temp <= DOUT3_temp;
    end if;
  end if;
end process;

DOUT1 <= DOUT1_temp;
DOUT2 <= DOUT2_temp;
DOUT3 <= DOUT3_temp;
DOUT4 <= DOUT4_temp;
		 
end Behavioral;

