----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    09:38:30 12/18/2008 
-- Design Name: 
-- Module Name:    UART_project - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
--
--  Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs are
--              provided to you "as is". Xilinx and its licensors make, and you
--              receive no warranties or conditions, express, implied,
--              statutory or otherwise, and Xilinx specifically disclaims any
--              implied warranties of merchantability, non-infringement, or
--              fitness for a particular purpose. Xilinx does not warrant that
--              the functions contained in these designs will meet your
--              requirements, or that the operation of these designs will be
--              uninterrupted or error free, or that defects in the Designs
--              will be corrected. Furthermore, Xilinx does not warrant or
--              make any representations regarding use or the results of the
--              use of the designs in terms of correctness, accuracy,
--              reliability, or otherwise.
--
--              LIMITATION OF LIABILITY. In no event will Xilinx or its
--              licensors be liable for any loss of data, lost profits, cost
--              or procurement of substitute goods or services, or for any
--              special, incidental, consequential, or indirect damages
--              arising from the use or operation of the designs or
--              accompanying documentation, however caused and on any theory
--              of liability. This limitation will apply even if Xilinx
--              has been advised of the possibility of such damage. This
--              limitation shall apply not-withstanding the failure of the
--              essential purpose of any limited remedies herein.
--
--  Copyright  2002, 2008 Xilinx, Inc.
--  All rights reserved
--
------------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.all;

--library UNISIM;
--use UNISIM.VComponents.all;

entity uart_RX_count is
  generic (
    CLOCK_RATE : integer := 100_000_000;
    BAUD_RATE  : integer :=  115_200
  );
  port (
    clk : in  std_logic;
    reset : in  std_logic;
    rxd : in  std_logic;
    DOUT1  : out std_logic_vector(4 downto 0);        
    DOUT2  : out std_logic_vector(4 downto 0);    
    DOUT3  : out std_logic_vector(4 downto 0);        
    DOUT4  : out std_logic_vector(4 downto 0)
  );
end uart_RX_count;


architecture Behavioral of uart_RX_count is

--
-- module definitions
--    
component uart_rx is
  generic (
    BAUD_RATE : integer := 115_200;                 -- serves as clock divisor
    CLOCK_RATE : integer := 100_000_000              -- freq of clk
  );
  port (
    rst_clk_rx         : in  std_logic;
    clk_rx             : in  std_logic;
    rxd_i              : in  std_logic;
    rxd_clk_rx         : out std_logic;
    rx_data            : out std_logic_VECTOR (7 downto 0);
    rx_data_rdy        : out std_logic;
    frm_err            : out std_logic
  );
end component uart_rx;  

component meta_harden is
  port (
    clk_dst    : in  std_logic;
    rst_dst    : in  std_logic;
    signal_src : in  std_logic;
    signal_dst : out  std_logic
  );
end component meta_harden;    
    
component led_ctl
  port(
   rst_clk_rx : IN std_logic;
   clk : IN std_logic;
   rx_data : IN std_logic_vector(7 downto 0);
   rx_data_rdy : IN std_logic;          
   DOUT1 : OUT std_logic_vector(4 downto 0);
   DOUT2 : OUT std_logic_vector(4 downto 0);
   DOUT3 : OUT std_logic_vector(4 downto 0);
   DOUT4 : OUT std_logic_vector(4 downto 0)
  );
end component;
    
-- clock and controls
signal  rst_clk_rx  : std_logic := 'U';
signal rx_data_rdy  : std_logic := 'U';
signal rx_data      : std_logic_vector(7 downto 0) := (others=>'U');
constant vcc        : std_logic := '1';
constant gnd        : std_logic := '0';
     
attribute keep : string; 
attribute keep of rx_data_rdy: signal is "TRUE";
attribute keep of rx_data: signal is "TRUE";

begin

--
-- define the buffers for the incoming data, clocks, and control
 
--
--
-- instantiate a metastability hardener for the incoming reset
meta_harden_rst_i0: meta_harden port map (
  rst_dst=>gnd,
  clk_dst=>clk,
  signal_src=>reset,
  signal_dst=>rst_clk_rx
);

--
-- And the button to switch LSB and MSB

--
-- instantiate the receiver side of the UART
uart_rx_i0: uart_rx
  generic map (
    BAUD_RATE   =>  BAUD_RATE,          -- serves as clock divisor
    CLOCK_RATE  => CLOCK_RATE           -- freq of clk
  )
  port map ( 
    rst_clk_rx      => rst_clk_rx,
    clk_rx          => clk,
    rxd_i           => rxd,
    rxd_clk_rx      => open,
    rx_data         => rx_data,
    rx_data_rdy     => rx_data_rdy,
    frm_err         => open -- this signal not used in this design
  );

--
-- instantiate the LED controller
led_ctl_i0: led_ctl port map (
  rst_clk_rx => rst_clk_rx,
  clk => clk,
  rx_data => rx_data,
  rx_data_rdy => rx_data_rdy,
  DOUT1 => DOUT1,
  DOUT2 => DOUT2,
  DOUT3 => DOUT3,
  DOUT4 => DOUT4
);

end Behavioral;

