//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    NEXYS4_TOP 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2015.4
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//--------------------------------------------------------------------------------

module ARTY_TOP(
	input			CLKIN,
	input			USER_RSTn,
	input	[3:0]	BTN,
	input	[3:0]	SW,
	input			RXD,
	output reg     	TXD,
	output			LD0_Red,
	output			LD0_Green,
	output			LD0_Blue,
	output			LD1_Red,
	output			LD1_Green,
	output			LD1_Blue,
	output			LD2_Red,
	output			LD2_Green,
	output			LD2_Blue,
	output			LD3_Red,
	output			LD3_Green,
	output			LD3_Blue,
	output reg		LD4,
	output reg		LD5,
	output reg		LD6,
	output reg		LD7
	);

	// -----------------
	wire	[4:0]	DOUT1,DOUT2,DOUT3,DOUT4;
	wire			CLK;
	reg 			RESET;
(* keep = "true" *)	wire		TXD_D;

	// attribute keep : string;
	// attribute keep of TXD_D: signal is "TRUE";

	always @(posedge CLK) begin
		RESET	<= ~USER_RSTn;
		TXD	    <= TXD_D;
		LD4		<= DOUT1[0] || SW[0];
		LD5		<= DOUT1[1] || SW[1];
		LD6		<= DOUT1[2] || SW[2];
		LD7		<= DOUT1[3] || SW[3];
	end

// U0  PLL_Block  Instance --
 PLL_Block U0
  (
  // Clock in ports
   .clk_in1(CLKIN),      // input clk_in1
   // Clock out ports
   .clk_out1(CLK),     // output clk_out1
   // Status and control signals
   .reset(RESET), // input reset
   .locked());      // output locked











//----------------------------

	Uart_TX	       U1 (
		.RESET(RESET),
		.CLK(CLK),
		.UART_TXD(TXD_D)
	);

	uart_RX_count U2 (
		.clk(CLK),
		.reset(RESET),
		.rxd(RXD),
		.DOUT1(DOUT1),
		.DOUT2(DOUT2),
		.DOUT3(DOUT3),
		.DOUT4(DOUT4)
	);

	RGB_controller U3 (
		.GCLK(CLK),
		.BTN(BTN),
		.LED0_O({LD0_Red,LD0_Blue,LD0_Green}),
		.LED1_O({LD1_Red,LD1_Blue,LD1_Green}),
		.LED2_O({LD2_Red,LD2_Blue,LD2_Green}),
		.LED3_O({LD3_Red,LD3_Blue,LD3_Green})
	);

endmodule