//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    NEXYS4_TOP 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------
//
//  Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs are
//              provided to you "as is". Xilinx and its licensors make, and you
//              receive no warranties or conditions, express, implied,
//              statutory or otherwise, and Xilinx specifically disclaims any
//              implied warranties of merchantability, non-infringement, or
//              fitness for a particular purpose. Xilinx does not warrant that
//              the functions contained in these designs will meet your
//              requirements, or that the operation of these designs will be
//              uninterrupted or error free, or that defects in the Designs
//              will be corrected. Furthermore, Xilinx does not warrant or
//              make any representations regarding use or the results of the
//              use of the designs in terms of correctness, accuracy,
//              reliability, or otherwise.
//
//              LIMITATION OF LIABILITY. In no event will Xilinx or its
//              licensors be liable for any loss of data, lost profits, cost
//              or procurement of substitute goods or services, or for any
//              special, incidental, consequential, or indirect damages
//              arising from the use or operation of the designs or
//              accompanying documentation, however caused and on any theory
//              of liability. This limitation will apply even if Xilinx
//              has been advised of the possibility of such damage. This
//              limitation shall apply not-withstanding the failure of the
//              essential purpose of any limited remedies herein.
//
//  Copyright  2002, 2008 Xilinx, Inc.
//  All rights reserved
//
//----------------------------------------------------------------------------------

module uart_RX_count #(
    parameter CLOCK_RATE = 100000000,                                      // clock rate
    parameter BAUD_RATE  = 115200                                          // desired baud rate
    )  (
	input			clk,
	input			reset,
	input			rxd,
	output	[4:0]	DOUT1,
	output	[4:0]	DOUT2,
	output	[4:0]	DOUT3,
	output	[4:0]	DOUT4
	);

	// clock and controls
	wire			rst_clk_rx;
(* keep = "true" *)	wire			rx_data_rdy;
(* keep = "true" *)	wire	[7:0]	rx_data;
    
//attribute keep : string; 
//attribute keep of rx_data_rdy: signal is "TRUE";
//attribute keep of rx_data: signal is "TRUE";

	//
	// define the buffers for the incoming data, clocks, and control
	//
    // instantiate a metastability hardener for the incoming reset

	meta_harden	meta_harden_rst_i0 (
		.rst_dst(1'b0),
		.clk_dst(clk),
		.signal_src(reset),
		.signal_dst(rst_clk_rx)
	);

	//
	// And the button to switch LSB and MSB

	uart_rx #(
           .CLOCK_RATE(CLOCK_RATE),
           .BAUD_RATE(BAUD_RATE)
        ) uart_rx_i0 (
		.rst_clk_rx(rst_clk_rx),
		.clk_rx(clk),
		.rxd_i(rxd),
		.rxd_clk_rx(),
		.rx_data(rx_data),
		.rx_data_rdy(rx_data_rdy),
		.frm_err()	// this signal not used in this design
	);

	// instantiate the LED controller
	led_ctl	led_ctl_i0 (
		.rst_clk_rx(rst_clk_rx),
		.clk(clk),
		.rx_data(rx_data),
		.rx_data_rdy(rx_data_rdy),
		.DOUT1(DOUT1),
		.DOUT2(DOUT2),
		.DOUT3(DOUT3),
		.DOUT4(DOUT4)
	);
endmodule
