//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    NEXYS4_TOP 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------

module NEXYS_TOP(
	input			CLKIN,
	input			RESET,
	input			USER_RST,
	input			RXD,
	input			START,
	input			DIR,
	output reg     	TXD,

	output			RGB1_Red,
	output			RGB1_Green,
	output			RGB1_Blue,
	output			RGB2_Red,
	output			RGB2_Green,
	output			RGB2_Blue,
	output	[7:0]	SEG7,
	output	[7:0]	AN
	);

	// -----------------
	wire	[3:0]	COUNT1, COUNT2, COUNT3, COUNT4;
	wire	[4:0]	COUNT5, COUNT6, COUNT7, COUNT8;
	wire			CLK;
	reg 			RESET1, DIR1, START1;
(* keep = "true" *)	wire			TXD_D;

	// attribute keep : string;
	// attribute keep of TXD_D: signal is "TRUE";

	always @(posedge CLK) begin
		RESET1	<= USER_RST;
		DIR1	<= DIR;
		START1	<= START;
		TXD	    <= TXD_D;
	end


// U0  PLL_Block  Instance --








//----------------------------

	Uart_TX	       U1 (
		.RESET(RESET1),
		.CLK(CLK),
		.UART_TXD(TXD_D)
	);

	counter_top    U2 (
		.CLK(CLK),
		.RESET(RESET1),
		.START(START1),
		.DIR(DIR1),
		.COUNT1(COUNT1),
		.COUNT2(COUNT2),
		.COUNT3(COUNT3),
		.COUNT4(COUNT4)
	);

	uart_RX_count U3 (
		.clk(CLK),
		.reset(RESET1),
		.rxd(RXD),
		.DOUT1(COUNT5),
		.DOUT2(COUNT6),
		.DOUT3(COUNT7),
		.DOUT4(COUNT8)
	);
	seg7_out	  U4 (
		.CLK(CLK),
		.RESET(RESET1),
		.COUNT1(COUNT1),
		.COUNT2(COUNT2),
		.COUNT3(COUNT3),
		.COUNT4(COUNT4),
		.COUNT5(COUNT5),
		.COUNT6(COUNT6),
		.COUNT7(COUNT7),
		.COUNT8(COUNT8),
		.SEG7(SEG7),
		.AN(AN)
	);
	
	RGB_controller U5 (
		.GCLK(CLK),
		.RGB_LED_1_O({RGB1_Red,RGB1_Blue,RGB1_Green}),
		.RGB_LED_2_O({RGB2_Red,RGB2_Blue,RGB2_Green})
	);

endmodule