//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    UART_TX 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision:1.00 
// Revision 1.00 - File converted to verilog
// Additional Comments: 
// 
//--------------------------------------------------------------------------------

module Uart_TX(
	input			RESET,
	input			CLK,
	output			UART_TXD
	);

	//UART_TX_CTRL control signals
(* keep = "true" *)	wire			uartRdy;
(* keep = "true" *)	wire			uartSend;
(* keep = "true" *)	wire	[7:0]	uartData;
(* keep = "true" *)	wire			uartTX;
	wire	[5:0]	addra;

	//Current uart state signal
	//attribute keep : string;
	//attribute keep of uartRdy: signal is "TRUE";
	//attribute keep of uartSend: signal is "TRUE";
	//attribute keep of uartData: signal is "TRUE";
	//attribute keep of uartTX: signal is "TRUE";

	Uart_TX_State	U1 (
		.CLK(CLK),
		.RESET(RESET),
		.uartSend(uartSend),
		.uartRdy(uartRdy),
		.Rom_addr(addra)
	);

	//Component used to send a byte of data over a UART line.
	UART_TX_CTRL	U2 (
		.SEND(uartSend),
		.DATA(uartData),
		.CLK(CLK),
		.READY(uartRdy),
		.UART_TX(uartTX)
	);
	
// U3   code_rom Instance ---






//-----------------------

	assign	UART_TXD	= uartTX;

endmodule
