//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    led_ctl 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------

module led_ctl(
	input			rst_clk_rx,	// reset signal synchronized with clk_rx
	input			clk,       	// operational clock
	input	[7:0]	rx_data,	// data received by uart_rx
	input			rx_data_rdy,// active high signal when rx_data is valid
	output	[4:0]	DOUT1,
	output	[4:0]	DOUT2,
	output	[4:0]	DOUT3,
	output	[4:0]	DOUT4
	);

	reg            last_rx_data_rdy;
	reg 	[7:0]	char_data;	// Captured character
	reg 	[4:0]	DOUT1_temp, DOUT2_temp, DOUT3_temp, DOUT4_temp;

	always @(posedge clk) begin
		// process only sensitive to clock
		// only on the rising edge of the clock (i.e. synchronous)
		if (rst_clk_rx == 1'b1) begin	// if the reset is active (sync reset)
			last_rx_data_rdy   <= 1'b0;
			char_data	       <= 8'b0;
		end else begin	// not a reset condition
			last_rx_data_rdy   <= rx_data_rdy;	// update the last state of the ready signal
			// detect the rising edge of rx_data_rdy and capture new data
			if ((rx_data_rdy != last_rx_data_rdy) && (rx_data_rdy == 1'b1)) begin	// look for both a change in the ready signal and the new state to be high
				char_data	<= rx_data;	// capture the new data
			end
		end
	end
	// end of rising edge of rx_data_rdy check
	// Select which set of bits get put on the low numbered LEDs and which go on the high LED
	// end of reset/normal operations
	// end of synchronous events
	always @(char_data) begin
		case (char_data)
		  8'h30:	DOUT1_temp	<= 5'b00000;
		  8'h31: 	DOUT1_temp	<= 5'b00001;
		  8'h32: 	DOUT1_temp	<= 5'b00010;
		  8'h33: 	DOUT1_temp	<= 5'b00011;
		  8'h34:	DOUT1_temp	<= 5'b00100;
		  8'h35:	DOUT1_temp	<= 5'b00101;
		  8'h36:	DOUT1_temp	<= 5'b00110;
		  8'h37:	DOUT1_temp	<= 5'b00111;
		  8'h38:	DOUT1_temp	<= 5'b01000;
		  8'h39:	DOUT1_temp	<= 5'b01001;
		  default:  DOUT1_temp	<= 5'b10000;
		endcase
	end

	always @(posedge clk or posedge rst_clk_rx) begin
		// process only sensitive to clock
		if (rst_clk_rx == 1'b1) begin	// if the reset is active (sync reset)
                DOUT2_temp	<= 5'b10000;
                DOUT3_temp	<= 5'b10000;
                DOUT4_temp	<= 5'b10000;
		end
		else if ((rx_data_rdy != last_rx_data_rdy) && (rx_data_rdy == 1'b1)) begin
				DOUT2_temp	<= DOUT1_temp;
				DOUT3_temp	<= DOUT2_temp;
				DOUT4_temp	<= DOUT3_temp;
		end
	end

	assign	DOUT1	= DOUT1_temp;
	assign	DOUT2	= DOUT2_temp;
	assign	DOUT3	= DOUT3_temp;
	assign	DOUT4	= DOUT4_temp;

endmodule