//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    seg7_out 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------


module seg7_out(
	input			CLK,
	input			RESET,
	input	[3:0]	COUNT1,
	input	[3:0]	COUNT2,
	input	[3:0]	COUNT3,
	input	[3:0]	COUNT4,
	input	[4:0]	COUNT5,
	input	[4:0]	COUNT6,
	input	[4:0]	COUNT7,
	input	[4:0]	COUNT8,
	output	reg [7:0]	SEG7,
	output	reg [7:0]	AN
	);

	reg 	[12:0]	Q;	// Boad
	reg 	[4:0]	COUNT_SEL;
	reg 			point;

	always @(posedge CLK) begin
		if (RESET == 1'b1) begin
			Q	<= 13'b0;
		end else begin
			Q	<= Q + 1;
		end
	end
	
	always @(posedge CLK) begin
		if (RESET == 1'b1) begin
			COUNT_SEL	<= 5'b00000;
			AN	<= 8'b11110000;
		end else begin
			case (Q[12:10])
			3'b000: begin
				COUNT_SEL	<= {1'b0, COUNT1};
				AN	<= 8'b11111110;
				point	<= 1'b1;
			end
			3'b001: begin
				COUNT_SEL	<= {1'b0, COUNT2};
				AN	<= 8'b11111101;
				point	<= 1'b0;
			end
			3'b010: begin
				COUNT_SEL	<= {1'b0, COUNT3};
				AN	<= 8'b11111011;
				point	<= 1'b1;
			end
			3'b011: begin
				COUNT_SEL	<= {1'b0, COUNT4};
				AN	<= 8'b11110111;
				point	<= 1'b1;
			end
			3'b100: begin
				COUNT_SEL	<= COUNT5;
				AN	<= 8'b11101111;
				point	<= 1'b1;
			end
			3'b101: begin
				COUNT_SEL	<= COUNT6;
				AN	<= 8'b11011111;
				point	<= 1'b1;
			end
			3'b110: begin
				COUNT_SEL	<= COUNT7;
				AN	<= 8'b10111111;
				point	<= 1'b1;
			end
			3'b111: begin
				COUNT_SEL	<= COUNT8;
				AN	<= 8'b01111111;
				point	<= 1'b1;
			end
			default: begin
				COUNT_SEL	<= 5'b00000;
				AN	<= 8'b11111111;
				point	<= 1'b1;
			end
			endcase
		end
	end

	always @(posedge CLK) begin
		SEG7[7]	<= point;
		case (COUNT_SEL)
		  5'b00000: 		SEG7[6:0]	<= 7'b1000000;
		  5'b00001: 		SEG7[6:0]	<= 7'b1111001;
		  5'b00010:			SEG7[6:0]	<= 7'b0100100;
		  5'b00011:			SEG7[6:0]	<= 7'b0110000;
		  5'b00100:			SEG7[6:0]	<= 7'b0011001;
		  5'b00101:			SEG7[6:0]	<= 7'b0010010;
		  5'b00110:			SEG7[6:0]	<= 7'b0000010;
		  5'b00111:			SEG7[6:0]	<= 7'b1011000;
		  5'b01000:			SEG7[6:0]	<= 7'b0000000;
		  5'b01001:			SEG7[6:0]	<= 7'b0010000;
		  default:			SEG7[6:0]	<= 7'b1111111;
		endcase
	end
	
endmodule