--------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    14:45:29 07/03/2014 
-- Design Name: 
-- Module Name:    count_uart_7seg_top - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity NEXYS_TOP is
  port (
    CLKIN : in  std_logic;
    RESET : in  std_logic;
    USER_RST: in  std_logic;
    RXD : in  std_logic;
    START : in  std_logic;
    DIR : in  std_logic;
    TXD : out  std_logic;
    RGB1_Red : out  std_logic;
    RGB1_Green : out  std_logic;
    RGB1_Blue : out  std_logic;
    RGB2_Red : out  std_logic;
    RGB2_Green : out  std_logic;
    RGB2_Blue : out  std_logic;
    SEG7 : out  std_logic_vector (7 downto 0);
    AN : out  std_logic_vector (7 downto 0)
  );
end NEXYS_TOP;

architecture Behavioral of NEXYS_TOP is

-- Compnent PLL_Block---@
component PLL_Block
port
 (-- Clock in ports
  -- Clock out ports
  clk_out1          : out    std_logic;
  -- Status and control signals
  reset             : in     std_logic;
  locked            : out    std_logic;
  clk_in1           : in     std_logic
 );
end component;
-------------------

component Uart_TX
  port(
    RESET : in std_logic;
    CLK : in std_logic;
    UART_TXD : out std_logic
  );
end component;

component counter_top
  port(
    CLK : in std_logic;
    RESET : in std_logic;
    START : in std_logic;
    DIR : in std_logic;
    COUNT1 : out std_logic_vector(3 downto 0);
    COUNT2 : out std_logic_vector(3 downto 0);
    COUNT3 : out std_logic_vector(3 downto 0);
    COUNT4 : out std_logic_vector(3 downto 0)
  );
end component;

component uart_RX_count
  port(
    CLK : in std_logic;
    RESET : in std_logic;
    RXD : in std_logic;
    DOUT1 : out std_logic_vector(4 downto 0);
    DOUT2 : out std_logic_vector(4 downto 0);
    DOUT3 : out std_logic_vector(4 downto 0);
    DOUT4 : out std_logic_vector(4 downto 0)
  );
end component;

component seg7_out
  port(
    CLK : in std_logic;
    RESET : in std_logic;
    COUNT1 : in std_logic_vector(3 downto 0);
    COUNT2 : in std_logic_vector(3 downto 0);
    COUNT3 : in std_logic_vector(3 downto 0);
    COUNT4 : in std_logic_vector(3 downto 0);
    COUNT5 : in std_logic_vector(4 downto 0);
    COUNT6 : in std_logic_vector(4 downto 0);
    COUNT7 : in std_logic_vector(4 downto 0);
    COUNT8 : in std_logic_vector(4 downto 0);
    SEG7 : out std_logic_vector(7 downto 0);
    AN : out std_logic_vector(7 downto 0)
  );
end component;

component RGB_controller 
  port(
    GCLK : in std_logic;
    RGB_LED_1_O : out std_logic_vector(2 downto 0);
    RGB_LED_2_O : out std_logic_vector(2 downto 0)
  );
end component;

signal COUNT1 : std_logic_vector(3 downto 0);
signal COUNT2 : std_logic_vector(3 downto 0);
signal COUNT3 : std_logic_vector(3 downto 0);
signal COUNT4 : std_logic_vector(3 downto 0);
signal COUNT5 : std_logic_vector(4 downto 0);
signal COUNT6 : std_logic_vector(4 downto 0);
signal COUNT7 : std_logic_vector(4 downto 0);
signal COUNT8 : std_logic_vector(4 downto 0);
signal CLK : std_logic;
signal RESET1 : std_logic;
signal DIR1 : std_logic;
signal START1: std_logic;
signal TXD_D : std_logic;
attribute keep : string;
attribute keep of TXD_D: signal is "TRUE";

begin

process (CLK) 
begin
  if CLK='1' and CLK'event then
    RESET1 <= USER_RST;
    DIR1 <= DIR;
    START1 <= START;
    TXD <= TXD_D;
  end if;
end process; 

-- U0  PLL_Block  Instance --@
U0 : PLL_Block
   port map ( 
  -- Clock out ports  
   clk_out1 => CLK,
  -- Status and control signals                
   reset => RESET,
   locked => open,
   -- Clock in ports
   clk_in1 => CLKIN
 );
------------------------------

U1: Uart_TX port map(
  RESET => RESET1,
  CLK => CLK,
  UART_TXD => TXD_D 
);

U2: counter_top port map(
  CLK => CLK,
  RESET => RESET1,
  START => START1,
  DIR => DIR1,
  COUNT1 => COUNT1,
  COUNT2 => COUNT2,
  COUNT3 => COUNT3,
  COUNT4 => COUNT4
);

U3: uart_RX_count port map(
  CLK => CLK,
  RESET => RESET1,
  RXD => RXD,
  DOUT1 => COUNT5,
  DOUT2 => COUNT6,
  DOUT3 => COUNT7,
  DOUT4 => COUNT8 
);

U4: seg7_out port map(
  CLK => CLK,
  RESET => RESET1,
  COUNT1 => COUNT1,
  COUNT2 => COUNT2,
  COUNT3 => COUNT3,
  COUNT4 => COUNT4,
  COUNT5 => COUNT5,
  COUNT6 => COUNT6,
  COUNT7 => COUNT7,
  COUNT8 => COUNT8,
  SEG7 => SEG7,
  AN => AN
);

U5: RGB_controller port map(
  GCLK => CLK,
  RGB_LED_1_O(0) => RGB1_Green,
  RGB_LED_1_O(1) => RGB1_Blue,
  RGB_LED_1_O(2) => RGB1_Red,
  RGB_LED_2_O(0) => RGB2_Green,
  RGB_LED_2_O(1) => RGB2_Blue,
  RGB_LED_2_O(2) => RGB2_Red
);

end Behavioral;
