library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

--  Uncomment the following lines to use the declarations that are
--  provided for instantiating Xilinx primitive components.
--library UNISIM;
--use UNISIM.VComponents.all;

entity counter_top is
  port (
    CLK : in std_logic;
    RESET : in std_logic;
    START : in std_logic;
    DIR : in std_logic;
    COUNT1 : out std_logic_vector(3 downto 0);
    COUNT2 : out std_logic_vector(3 downto 0);
    COUNT3 : out std_logic_vector(3 downto 0);
    COUNT4 : out std_logic_vector(3 downto 0)
  );
end counter_top;

architecture Behavioral of counter_top is

--- Component ------

component counter
  port(
    CLK : IN std_logic;
    RESET : IN std_logic;
    CE : IN std_logic;
    UP_DW : IN std_logic;          
    CARRY : OUT std_logic;
    DOUT : OUT std_logic_vector(3 downto 0)
  );
end component;

component bunshu
  port(
    CLK : IN std_logic;
    RST : IN std_logic;          
    CEOUT : OUT std_logic
  );
end component;

signal CE,CE1,CE2,CE3,CE4: std_logic;

begin

CE1 <= START and CE;

----- port map ------

U1: bunshu port map(
  CLK => CLK,
  RST => RESET,
  CEOUT => CE
);

U2: counter port map(
  CLK => CLK,
  RESET => RESET,
  CE => CE1,
  UP_DW => DIR,
  CARRY => CE2,
  DOUT => COUNT1
);

U3: counter port map(
  CLK => CLK,
  RESET => RESET,
  CE => CE2,
  UP_DW => DIR,
  CARRY => CE3,
  DOUT => COUNT2
);

U4: counter port map(
  CLK => CLK,
  RESET => RESET,
  CE => CE3,
  UP_DW => DIR,
  CARRY => CE4,
  DOUT => COUNT3
);

U5: counter port map(
  CLK => CLK,
  RESET => RESET,
  CE => CE4,
  UP_DW => DIR,
  CARRY => open,
  DOUT => COUNT4
);

end Behavioral;
