//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    counter 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------

module counter(
	input			CLK,
	input			RESET,
	input			CE,
	input			UP_DW,
	output	reg		CARRY,
	output	[3:0]   DOUT
	);

	reg 	[3:0]   COUNT;

	always @(posedge CLK) begin
		if (RESET == 1'b1) begin
			COUNT	<= 4'b0;
		end else if (CE == 1'b1) begin
			if (UP_DW == 1'b1) begin
				if (COUNT == 4'b1001) begin
					COUNT	<= 4'b0000;
				end else begin
					COUNT	<= COUNT + 1;
				end
			end else begin
				if (COUNT == 4'b0000) begin
					COUNT	<= 4'b1001;
				end else begin
					COUNT	<= COUNT - 1;
				end
			end
		end
	end
	
	always @(COUNT or CE or UP_DW) begin
		if (UP_DW == 1'b1) begin
			if (COUNT == 4'b1001 && CE == 1'b1) begin
				CARRY	<= 1'b1;
			end else begin
				CARRY	<= 1'b0;
			end
		end else begin
			if (COUNT == 4'b0000 && CE == 1'b1) begin
				CARRY	<= 1'b1;
			end else begin
				CARRY	<= 1'b0;
			end
		end
	end

	assign	DOUT	= COUNT;

endmodule
