//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    counter_top 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------

module counter_top(
	input			CLK,
	input			RESET,
	input			START,
	input			DIR,
	output	[3:0]	COUNT1,
	output	[3:0]	COUNT2,
	output	[3:0]	COUNT3,
	output	[3:0]	COUNT4
	);

	wire			CE, CE1, CE2, CE3, CE4;

	assign	CE1	= START & CE;

	//--- port map ------

	bunshu	U1 (
		.CLK(CLK),
		.RST(RESET),
		.CEOUT(CE)
	);

	counter	U2 (
		.CLK(CLK),
		.RESET(RESET),
		.CE(CE1),
		.UP_DW(DIR),
		.CARRY(CE2),
		.DOUT(COUNT1)
	);
	
	counter	U3 (
		.CLK(CLK),
		.RESET(RESET),
		.CE(CE2),
		.UP_DW(DIR),
		.CARRY(CE3),
		.DOUT(COUNT2)
	);

	counter	U4 (
		.CLK(CLK),
		.RESET(RESET),
		.CE(CE3),
		.UP_DW(DIR),
		.CARRY(CE4),
		.DOUT(COUNT3)
	);
	
	counter	U5 (
		.CLK(CLK),
		.RESET(RESET),
		.CE(CE4),
		.UP_DW(DIR),
		.CARRY(open),
		.DOUT(COUNT4)
	);
	
endmodule