----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    14:21:07 07/03/2014 
-- Design Name: 
-- Module Name:    seg7_out - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity seg7_out is
  port (
    CLK : in  STD_LOGIC;
    RESET : in  STD_LOGIC;
    COUNT1 : in std_logic_vector(3 downto 0);
    COUNT2 : in std_logic_vector(3 downto 0);
    COUNT3 : in std_logic_vector(3 downto 0);
    COUNT4 : in std_logic_vector(3 downto 0);
    COUNT5 : in std_logic_vector(4 downto 0);
    COUNT6 : in std_logic_vector(4 downto 0);
    COUNT7 : in std_logic_vector(4 downto 0);
    COUNT8 : in std_logic_vector(4 downto 0);
    SEG7 : out std_logic_vector(7 downto 0);
    AN : out std_logic_vector(7 downto 0)
  );
end seg7_out;

architecture Behavioral of seg7_out is

signal Q : std_logic_vector(12 downto 0); -- Boad
signal COUNT_SEL :  std_logic_vector(4 downto 0);
signal point :std_logic;
--signal Q : std_logic_vector(1 downto 0); -- SIM
begin

process(CLK) begin
  if CLK'event and CLK='1' then
    if RESET = '1' then
      Q <= ( others=>'0');
    else
      Q <= Q + 1;
    end if;
  end if;
end process;

process(CLK) begin
  if (CLK'event and CLK = '1')then
    if (RESET = '1')then
      COUNT_SEL <= "00000"; AN <= "11110000";
    else
      case Q(12 downto 10) is
      when "000" => COUNT_SEL <= '0' &COUNT1; AN <= "11111110"; point <= '1';
      when "001" => COUNT_SEL <= '0' &COUNT2; AN <= "11111101"; point <= '0';
      when "010" => COUNT_SEL <= '0' &COUNT3; AN <= "11111011"; point <= '1';
      when "011" => COUNT_SEL <= '0' &COUNT4; AN <= "11110111"; point <= '1';
      when "100" => COUNT_SEL <= COUNT5; AN <= "11101111"; point <= '1';
      when "101" => COUNT_SEL <= COUNT6; AN <= "11011111"; point <= '1';
      when "110" => COUNT_SEL <= COUNT7; AN <= "10111111"; point <= '1';
      when "111" => COUNT_SEL <= COUNT8; AN <= "01111111"; point <= '1';
      when others =>COUNT_SEL <= "00000"; AN <= "11111111"; point <= '1';
      end case;
    end if;  
  end if;
end process;

process(CLK) begin
  if (CLK'event and CLK = '1')then
    SEG7(7) <= point;
    case COUNT_SEL is
    when "00000" => SEG7(6 downto 0)  <= "1000000"; 
    when "00001" => SEG7(6 downto 0)  <= "1111001";
    when "00010" => SEG7(6 downto 0)  <= "0100100";
    when "00011" => SEG7(6 downto 0)  <= "0110000"; 
    when "00100" => SEG7(6 downto 0)  <= "0011001";
    when "00101" => SEG7(6 downto 0)  <= "0010010";
    when "00110" => SEG7(6 downto 0)  <= "0000010";
    when "00111" => SEG7(6 downto 0)  <= "1011000";
    when "01000" => SEG7(6 downto 0)  <= "0000000";
    when "01001" => SEG7(6 downto 0)  <= "0010000";
    when others => SEG7(6 downto 0)  <= "1111111";  
    end case;
  end if;
end process;

end Behavioral;

