--<insert: c:\HW\releasedULD\headers\uart_led_pkg.head>
-- -----------------------------------------------------------------------------
--
-- module:    uart_led_pkg
-- project:   uart_led
-- company:   Xilinx, Inc.
-- author:    WK, AW
-- 
-- comment:
--   This package provides a convenient mechanism for encapsulating all of the
--   modules used in the uart_led project. To access these module definitions,
--   all one must do is name the library where the package is
--   stored and implement a  use  statement. Typically, this module may reside
--   where all the other VHDL sources exist and, by default, this file will
--   appear in the  WORK  library. The  WORK  library is accessed by default so
--   the  library work;  statement is optional. The next line should read  use
--   WORK.uart_led_pkg.all; which will make all of the contents of this package
--   available to the file in which this statement exists.
--
--   Note that only modules that make use of any of the contents in this package 
--   are required to explicitly connect to it.
--
--   The package also includes a number of constants and user defined enumerated 
--   types. 
--
--   As a rule of thumb, I place all the component instantiations in a package 
--   to reduce the  clutter 
--   within a file.
--
--   Types, subtypes, functions, procedures, and constant are included if they are 
--   used by more than one module. This reduces errors due to inconsistant usage.
-- 
-- known issues:
-- status           id     found     description                      by fixed date  by    comment
-- 
-- version history:
--   version    date    author     description
--    11.1-001 20 APR 2009 WK       New for version 11.1            
-- 
-- ---------------------------------------------------------------------------
-- 
-- disclaimer:
--   Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs  are
--   provided to you as is . Xilinx and its licensors make, and  you
--   receive no warranties or conditions, express,  implied,
--   statutory or otherwise, and Xilinx specifically disclaims  any
--   implied warranties of merchantability, non-infringement,  or
--   fitness for a particular purpose. Xilinx does not warrant  that
--   the functions contained in these designs will meet  your
--   requirements, or that the operation of these designs will  be
--   uninterrupted or error free, or that defects in the  Designs
--   will be corrected. Furthermore, Xilinx does not warrant  or
--   make any representations regarding use or the results of  the
--   use of the designs in terms of correctness,  accuracy,
--   reliability, or  otherwise.
--   
-- LIMITATION OF LIABILITY. In no event will Xilinx or  its
--   licensors be liable for any loss of data, lost profits,  cost
--   or procurement of substitute goods or services, or for  any
--   special, incidental, consequential, or indirect  damages
--   arising from the use or operation of the designs  or
--   accompanying documentation, however caused and on any  theory
--   of liability. This limitation will apply even if  Xilinx
--   has been advised of the possibility of such damage.  This
--   limitation shall apply not-withstanding the failure of  the
--   essential purpose of any limited remedies  herein.
--   
-- Copyright  2002, 2008, 2009 Xilinx,  Inc.
--   All rights reserved
-- 
-- -----------------------------------------------------------------------------
--

library IEEE;
use IEEE.STD_LOGIC_1164.all;


package uart_led_pkg is

    -- 
    -- Device constants
    --
    
    -- Number of bits of address for the Sample RAM - RAM can hold 2^NSAMP_WID
    -- Since NSAMP is coded "naturally" (from 1 to 2**NSAMP_WID, rather than
    -- from 0 to 2**(NSAMP_WID)-1), an extra bit is required in things that
    -- carry the actual value of nsamp. However, the RAM address is coded
    -- 0 to 2**NSAMP_WID-1
    constant NSAMP_WIDTH             : integer := 10;        

    --
    -- specialized types
    --
    type RESPONSE_TYPE is (ACK, ERR, DATA, UNKNOWN);
    
    
    --
    -- component definitions
    --
    
    
    component uart_rx is
       generic (
         BAUD_RATE   : integer :=     115_200;                 -- serves as clock divisor
         CLOCK_RATE  : integer := 100_000_000                  -- freq of clk
       );
       port (
         rst_clk_rx      : in  std_logic;                       -- active high, managed synchronously
         clk_rx          : in  std_logic;                       -- operational clock
         rxd_i           : in  std_logic;                       -- directly from pad - not yet associated with any time domain
         rx_data         : out std_logic_VECTOR (7 downto 0);   -- 8 bit data output valid when rx_data_rdy is asserted
         rx_data_rdy     : out std_logic;                       -- active high signal indicating rx_data is valid
         frm_err         : out std_logic                        -- framing error - active high when STOP bit not detected
       );
    end component uart_rx;  
    
    
    component meta_harden is
      port (
        clk_dst      : in  std_logic;
        rst_dst      : in  std_logic;
        signal_src   : in  std_logic;
        signal_dst   : out std_logic
      );
    end component meta_harden;    
    

    component uart_baud_gen is
      generic (
        CLOCK_RATE       : integer := 100_000_000;              -- clock rate
        BAUD_RATE        : integer :=     115_200               -- desired baud rate
      );                   
      port (
        rst                : in  std_logic;                       -- external reset in
        clk                : in  std_logic;                       -- clock 
        baud_x16_en        : out std_logic
      );
    end component uart_baud_gen;
    
    component uart_rx_ctl
       port(
         clk_rx      : in  std_logic;
         rst_clk_rx  : in  std_logic;
         baud_x16_en : in  std_logic;
         rxd_clk_rx  : in  std_logic;          
         rx_data     : out std_logic_vector(7 downto 0);
         rx_data_rdy : out std_logic;
         frm_err     : out std_logic
       );
    END component uart_rx_ctl;    
    
    --
    -- handy constants
    constant vcc               : std_logic_vector(31 downto 0) := (others=>'1');
    constant gnd               : std_logic_vector(31 downto 0) := (others=>'0');


end uart_led_pkg;


package body uart_led_pkg is

end uart_led_pkg;
