//----------------------------------------------------------------------------------
// Company:        hdLab
// Engineer:       K.Date
// 
// Create Date:    06/15/2015 
// Design Name:    NEXYS4_verilog
// Module Name:    RGB_controller 
// Project Name:   NEXYS4
// Target Devices: Artix-7
// Tool versions:  Vivado2014.3
// Description: 
//
// Dependencies: 
//
// Revision: 1.00
// Revision 1.00 - File converted to verilog
// Additional Comments: 
//
//--------------------------------------------------------------------------------

module RGB_controller(
	input			GCLK,
	output	[2:0]	RGB_LED_1_O,
	output	[2:0]	RGB_LED_2_O
	);

	parameter	window	= 8'b11111111;
	reg 	[7:0]	windowcount;
	parameter	window1	= 8'b11111111;
	reg 	[7:0]	windowcount1;

	//        std_logic_vector(to_unsigned(1000000, 20));
	parameter	deltacountMax	= 20'hf4240; // 

	reg 	[19:0]	deltacount;
	parameter	valcountMax	= 9'b101111111;
	reg 	[8:0]	valcount;

	//color intensity signals
	wire	[7:0]	incVal;
	wire	[7:0]	decVal;

	wire	[7:0]	redVal;
	wire	[7:0]	greenVal;
	wire	[7:0]	blueVal;
	wire	[7:0]	redVal2;
	wire	[7:0]	greenVal2;
	wire	[7:0]	blueVal2;
	//PWM registers
	reg 	[2:0]	rgbLedReg1;
	reg 	[2:0]	rgbLedReg2;

	always @(posedge GCLK) begin
			if (windowcount < (window)) begin
				windowcount	<= windowcount + 1;
			end else begin
				windowcount	<= 8'b0;
			end
	end

	always @(posedge GCLK) begin
			if (windowcount1 < (window1)) begin
				windowcount1	<= windowcount1 + 1;
			end else begin
				windowcount1	<= 8'b0;
			end
	end

	always @(posedge GCLK) begin
			if (deltacount < deltacountMax) begin
				deltacount	<= deltacount + 1;
			end else begin
				deltacount	<= 20'b0;
			end
	end

	always @(posedge GCLK) begin
			if (deltacount == 0) begin
				if (valcount < valcountMax) begin
					valcount	<= valcount + 1;
				end else begin
					valcount	<= 9'b0;
				end
			end
	end

	assign	incVal	= {1'b0, valcount[6:0]};

	//The folowing code sets decVal to (128 - incVal)
	assign	decVal[7]	= 1'b0;
	assign	decVal[6]	=  ~(valcount[6]);
	assign	decVal[5]	=  ~(valcount[5]);
	assign	decVal[4]	=  ~(valcount[4]);
	assign	decVal[3]	=  ~(valcount[3]);
	assign	decVal[2]	=  ~(valcount[2]);
	assign	decVal[1]	=  ~(valcount[1]);
	assign	decVal[0]	=  ~(valcount[0]);

	assign	redVal	= ((valcount[8:7] == 2'b00)) ? (incVal)
				: (((valcount[8:7] == 2'b01)) ? (decVal)
				: 8'b0);
	assign	greenVal	= ((valcount[8:7] == 2'b00)) ? (decVal)
				: (((valcount[8:7] == 2'b01)) ? (8'b0)
				: (incVal));
	assign	blueVal	= ((valcount[8:7] == 2'b00)) ? (8'b0)
				: (((valcount[8:7] == 2'b01)) ? (incVal)
				: (decVal));
	assign	redVal2	= ((valcount[8:7] == 2'b00)) ? (incVal)
				: (((valcount[8:7] == 2'b01)) ? (decVal)
				: (8'b0));
	assign	greenVal2	= ((valcount[8:7] == 2'b00)) ? (decVal)
				: (((valcount[8:7] == 2'b01)) ? (8'b0)
				: (incVal));
	assign	blueVal2	= ((valcount[8:7] == 2'b00)) ? (8'b0)
				: (((valcount[8:7] == 2'b01)) ? (incVal)
				: (decVal));

	//red processes
	always @(posedge GCLK) begin
			if ((redVal) > windowcount) begin
				rgbLedReg1[2]	<= 1'b1;
			end else begin
				rgbLedReg1[2]	<= 1'b0;
			end
	end

	//green processes
	always @(posedge GCLK) begin
			if ((greenVal) > windowcount) begin
				rgbLedReg1[1]	<= 1'b1;
			end else begin
				rgbLedReg1[1]	<= 1'b0;
			end
	end

	//blue processes
	always @(posedge GCLK) begin
			if ((blueVal) > windowcount) begin
				rgbLedReg1[0]	<= 1'b1;
			end else begin
				rgbLedReg1[0]	<= 1'b0;
			end
	end
	//RGB2 processes---	
	//red2 processes
	always @(posedge GCLK) begin
			if ((redVal2) > windowcount1) begin
				rgbLedReg2[2]	<= 1'b1;
			end else begin
				rgbLedReg2[2]	<= 1'b0;
			end
	end

	//green2 processes
	always @(posedge GCLK) begin
			if ((greenVal2) > windowcount1) begin
				rgbLedReg2[1]	<= 1'b1;
			end else begin
				rgbLedReg2[1]	<= 1'b0;
			end
	end

	//blue2 processes
	always @(posedge GCLK) begin
			if ((blueVal2) > windowcount1) begin
				rgbLedReg2[0]	<= 1'b1;
			end else begin
				rgbLedReg2[0]	<= 1'b0;
			end
	end

	assign	RGB_LED_1_O	= rgbLedReg1;
	assign	RGB_LED_2_O	= rgbLedReg2;

endmodule