proc boot_jtag { } {
############################
# Switch to JTAG boot mode #
############################
targets -set -filter {name =~ "PSU"}
# update multiboot to ZERO
mwr 0xffca0010 0x0
# change boot mode to JTAG
mwr 0xff5e0200 0x0100
# reset
rst -system
}


              
set PMUFW_DIR C:/training/Kria_work/Vitis_workspace/add_bram_wrapper/export/add_bram_wrapper/sw/add_bram_wrapper/boot

set FSBL_DIR  C:/training/Kria_work/Vitis_workspace/add_bram_wrapper/export/add_bram_wrapper/sw/add_bram_wrapper/boot

set BIT_DIR   C:/training/Kria_work/Vitis_workspace/add_bram_wrapper/hw/

set APP_DIR   C:/training/Kria_work/Vitis_workspace/hello_world/Debug

connect
boot_jtag

after 2000
targets -set -filter {name =~ "PSU"}
fpga "$BIT_DIR/add_bram_wrapper.bit"
mwr 0xffca0038 0x1FF

# Download pmufw.elf
targets -set -filter {name =~ "MicroBlaze PMU"}
after 500
dow "$PMUFW_DIR/pmufw.elf"
con
after 500

# Select A53 Core 0
targets -set -filter {name =~ "Cortex-A53 #0"}
rst -processor -clear-registers
dow "$FSBL_DIR/fsbl.elf"
con
after 10000
stop


dow "$APP_DIR/hello_world.elf"
after 500
con