#-----------------------------------------------------------
# Vivado v2022.1 (64-bit)
#-----------------------------------------------------------
start_gui

# 1. Create project
#    Project name:	Kria_baremetal
#    Location: 		C:/training/Kria_work/Kria_baremetal
#    Part no.:		xck26-sfvc784-2LV-c
create_project Kria_baremetal C:/training/Kria_work/Kria_baremetal -part xck26-sfvc784-2LV-c
set_property board_part xilinx.com:kv260_som:part0:1.3 [current_project]
set_property board_connections {som240_1_connector xilinx.com:kv260_carrier:som240_1_connector:1.3} [current_project]

# 2. Create block design
create_bd_design "add_bram"
update_compile_order -fileset sources_1

# 3. IPs
startgroup
create_bd_cell -type ip -vlnv xilinx.com:ip:zynq_ultra_ps_e:3.4 zynq_ultra_ps_e_0
endgroup

apply_bd_automation -rule xilinx.com:bd_rule:zynq_ultra_ps_e -config {apply_board_preset "1" }  [get_bd_cells zynq_ultra_ps_e_0]

startgroup
create_bd_cell -type ip -vlnv xilinx.com:ip:axi_bram_ctrl:4.1 axi_bram_ctrl_0
endgroup

# 4. Customize IPs
startgroup
apply_bd_automation -rule xilinx.com:bd_rule:bram_cntlr -config {BRAM "Auto" }  [get_bd_intf_pins axi_bram_ctrl_0/BRAM_PORTA]
apply_bd_automation -rule xilinx.com:bd_rule:axi4 -config { Clk_master {Auto} Clk_slave {Auto} Clk_xbar {Auto} Master {/zynq_ultra_ps_e_0/M_AXI_HPM0_FPD} Slave {/axi_bram_ctrl_0/S_AXI} ddr_seg {Auto} intc_ip {New AXI SmartConnect} master_apm {0}}  [get_bd_intf_pins axi_bram_ctrl_0/S_AXI]
endgroup

# 5. Customize AXI BRAM Controller
startgroup
set_property -dict [list CONFIG.SINGLE_PORT_BRAM {1}] [get_bd_cells axi_bram_ctrl_0]
endgroup

# 6. Customize Zynq MPSoC
startgroup
set_property -dict [list CONFIG.PSU__USE__M_AXI_GP1 {0}] [get_bd_cells zynq_ultra_ps_e_0]
endgroup

# 7. Validate block design
regenerate_bd_layout
validate_bd_design

# 8. Product Output
set_property synth_checkpoint_mode None [get_files  C:/training/Kria_work/Kria_baremetal/Kria_baremetal.srcs/sources_1/bd/add_bram/add_bram.bd]
generate_target all [get_files  C:/training/Kria_work/Kria_baremetal/Kria_baremetal.srcs/sources_1/bd/add_bram/add_bram.bd]

# 9. 
export_ip_user_files -of_objects [get_files C:/training/Kria_work/Kria_baremetal/Kria_baremetal.srcs/sources_1/bd/add_bram/add_bram.bd] -no_script -sync -force -quiet
export_simulation -of_objects [get_files C:/training/Kria_work/Kria_baremetal/Kria_baremetal.srcs/sources_1/bd/add_bram/add_bram.bd] -directory C:/training/Kria_work/Kria_baremetal/Kria_baremetal.ip_user_files/sim_scripts -ip_user_files_dir C:/training/Kria_work/Kria_baremetal/Kria_baremetal.ip_user_files -ipstatic_source_dir C:/training/Kria_work/Kria_baremetal/Kria_baremetal.ip_user_files/ipstatic -lib_map_path [list {modelsim=C:/training/Kria_work/Kria_baremetal/Kria_baremetal.cache/compile_simlib/modelsim} {questa=C:/training/Kria_work/Kria_baremetal/Kria_baremetal.cache/compile_simlib/questa} {riviera=C:/training/Kria_work/Kria_baremetal/Kria_baremetal.cache/compile_simlib/riviera} {activehdl=C:/training/Kria_work/Kria_baremetal/Kria_baremetal.cache/compile_simlib/activehdl}] -use_ip_compiled_libs -force -quiet

# 10. Create HDL wrapper
make_wrapper -files [get_files C:/training/Kria_work/Kria_baremetal/Kria_baremetal.srcs/sources_1/bd/add_bram/add_bram.bd] -top

# 11. Synthesis, Place & Routing and Generate Bitstream
add_files -norecurse c:/training/Kria_work/Kria_baremetal/Kria_baremetal.gen/sources_1/bd/add_bram/hdl/add_bram_wrapper.v
launch_runs impl_1 -to_step write_bitstream -jobs 8
wait_on_run impl_1

# 12. Make and Export .xsa to Vitis
write_hw_platform -fixed -include_bit -force -file C:/training/Kria_work/Vitis_workspace/add_bram_wrapper.xsa
