###########################################################################
# Project_Flow Completer Script
###########################################################################

# load the standard helper file
source c:/training/completer_helper_script/completer_helper.tcl

# project constants
set verbose 	1
set tcName 		IO_PinPlanning
set demoOrLab 	completed
set projName 	uart_led

############################################################
# Step 1 : Creating a new project and adding source files
############################################################
proc createProj {} {
 variable language
 variable platform
 variable tcName
 variable demoOrLab
 variable projName
# Creates the project, adds source files
 projectCreate 
 sourcesAdd
  if {$platform == "KC705"} {
 import_files -norecurse C:/training/$tcName/$demoOrLab/$platform/$language/clk_core.xci
 }
 constraintFilesAdd
}

############################################################
# Step 2 : Analyzing the Design and viewing DRC violations
############################################################
proc drcCheck {} {
 variable platform
 variable language
 variable tcName
 variable demoOrLab 
 variable projName
set projName.srcs {append $projName .srcs}

 if {$platform == "KC705"} {
  generate_target all [get_files  C:/training/$tcName/$demoOrLab/$platform/$language/$projName.srcs/sources_1/ip/clk_core/clk_core.xci]
  create_ip_run [get_files -of_objects [get_fileset sources_1] C:/training/$tcName/$demoOrLab/$platform/$language/$projName.srcs/sources_1/ip/clk_core/clk_core.xci]
  launch_runs -jobs 4 clk_core_synth_1
  wait_on_run clk_core_synth_1
}
  set_property top uart_led [current_fileset]
  synth_design -rtl -name rtl_1
  report_drc -name drc_1 -ruledecks {default}
  markLastStep drcCheck	   
} 
	
############################################################
#Step 3 : Placing the Pins
############################################################
proc placePins {} {
 variable platform
 variable language
 variable tcName
 variable demoOrLab 
 variable projName

set projName.srcs {append $projName .srcs}
if {$platform == "KCU105"} {
  place_ports btn_pin AE10
  set_property IOSTANDARD LVCMOS18 [get_ports [list btn_pin]]
  place_ports rxd_pin G25
  set_property IOSTANDARD LVCMOS18 [get_ports [list rxd_pin]]
  place_ports rst_pin AN8
  set_property IOSTANDARD LVCMOS18 [get_ports [list rst_pin]]
} elseif {$platform == "KC705"} {
  place_ports btn_pin Y29
  set_property IOSTANDARD LVCMOS25 [get_ports [list btn_pin]]
  place_ports rxd_pin M19
  set_property IOSTANDARD LVCMOS25 [get_ports [list rxd_pin]]
  place_ports rst_pin AK4
  set_property IOSTANDARD LVCMOS15 [get_ports [list rst_pin]]
}

save_constraints_as constrs_2 -target_constrs_file uart_led.xdc
set_property constrset constrs_2 [get_runs synth_1]
set_property constrset constrs_2 [get_runs impl_1] 

report_drc -name drc_2 -ruledecks {default}
markLastStep placedPins

} 

##########################################################
# Running through the steps that are required, with make
##########################################################
proc make {stopAt} {
   puts "Running until the step $stopAt"
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { createProj }
      step2  { make step1; drcCheck }
      step3  { make step2; placePins }
      all    { make step3 }
      
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}