###########################################################################
## Resets Completer Script
###########################################################################

# load the standard helper file
source C:/training/completer_helper_script/completer_helper.tcl

# project constants
set verbose 	1
set tcName 		Reset
set demoOrLab 	completed


 ## *********** Step 1 : Opening async_reset project and examine ***********

proc openProj_async_reset {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 

set projName 	async_reset

# Add the platform and language combination that you want 
set isLangNotSelected [string compare -nocase $language "undefined"]
set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
}   

# Open a project
set projName.xpr {append $projName .xpr}
open_project C:/training/$tcName/$demoOrLab/$platform/$projName/$projName.xpr


set synth 0	
# Calling the proc which runs implementation
synthesisRun $synth

select [get_cells SysRst_L*]
report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
report_timing -from [get_ports {SysRst_L}] -max_paths 100 -name async_timing_paths
get_property INIT [get_cells *count_reg[0][0]]
get_property INIT [get_cells sload_in_reg]
report_high_fanout_nets
select [get_nets async_reset_L]
close_design

set impl 0	
# Calling the proc which runs implementation
implementationRun $impl

report_high_fanout_nets
select [get_nets async_reset_L]
join [get_pins -of [get_nets async_reset_L]] \n
llength [get_pins -of [get_nets async_reset_L]]
close_design
close_project
}


 ## *********** Step 2 : Opening no_reset project and examine ***********

proc openProj_no_reset {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 

set projName 	no_reset

# Add the platform and language combination that you want 
set isLangNotSelected [string compare -nocase $language "undefined"]
set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
}   

# Open a project
set projName.xpr {append $projName .xpr}
open_project C:/training/$tcName/$demoOrLab/$platform/$projName/$projName.xpr


set synth 0	
# Calling the proc which runs implementation
synthesisRun $synth

report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
get_property INIT [get_cells sload_in_reg*]
close_design

set impl 0	
# Calling the proc which runs implementation
implementationRun $impl

select [get_cells sload_in_reg]
report_high_fanout_nets
close_design
close_project
}

 ## *********** Step 3 : Opening sync_reset project and examine ***********

proc openProj_sync_reset {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 

set projName 	sync_reset

# Add the platform and language combination that you want 
set isLangNotSelected [string compare -nocase $language "undefined"]
set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
}   

# Open a project
set projName.xpr {append $projName .xpr}
open_project C:/training/$tcName/$demoOrLab/$platform/$projName/$projName.xpr


synth_design -rtl -name rtl_1

select [get_cells RESET_BRIDGE_100]
close_design

set synth 0
# Calling the proc which runs implementation
synthesisRun $synth

report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
report_high_fanout_nets
all_fanout -endpoints_only -flat [get_nets RESET_BRIDGE_100/sync_reset_out]
llength [all_fanout -endpoints_only -flat [get_nets RESET_BRIDGE_100/sync_reset_out]]
report_timing -through [get_nets {RESET_BRIDGE_100/sync_reset_out}] -name reset_timing_paths -max_paths 10
close_design
}


 ## *********** Step 4 : Moving high fan out signal ***********

proc move_highfanout_signal {} {

set_property verilog_define SYNC_RESET_ON_BUFG=1 [current_fileset]
reset_run synth_1

set synth 1
# Calling the proc which runs implementation
synthesisRun $synth

report_high_fanout_nets
select [get_cells RESET_BRIDGE_100]
report_timing -through [get_nets {reset_clk100}] -name reset_timing_paths -max_paths 10
close_design
close_project
}


 ## ********** Running only the steps that are required with Make **************

proc make {stopAt} {

   puts "Running until the step $stopAt"
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { openProj_async_reset }
      step2  { make step1; openProj_no_reset }
      step3  { make step2; openProj_sync_reset }
      step4  { make step3; move_highfanout_signal }
      all    { make step4 }
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}
