//Parallel input - Serial output
module piso (clk, SLOAD, PI, SO);

parameter WIDTH = 4;

input clk;
input SLOAD;
input [WIDTH - 1 : 0] PI;
output SO;

reg [WIDTH - 1 : 0] tmp;
always @(posedge clk)
        begin
                if(WIDTH == 1)
                        tmp = PI;
                else
                begin
                        if (SLOAD)
                                tmp = PI;
                        else
                                tmp = {tmp[WIDTH - 2: 0], 1'b1};
                end
        end

assign SO = tmp[WIDTH - 1];

endmodule
