###########################################################################
## Baselining Completer Script
###########################################################################

# load the standard helper file
source C:/training/completer_helper_script/completer_helper.tcl

# project constants
set verbose 	1
set tcName 		Baselining
set demoOrLab 	completed
set projName 	uart_led

 ## *********** Step 1 : Opening a project ***********

proc openProject {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 

# Add the platform and language combination that you want 
set isLangNotSelected [string compare -nocase $language "undefined"]
set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
if {$isLangNotSelected} {
      puts "Please type: use VHDL | Verilog"
      puts "   then rerun the projectCreate"
} 
if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
}

# Open a project
set projName.xpr {append $projName .xpr}
open_project C:/training/$tcName/$demoOrLab/$platform/$language/$projName.xpr
}


 ## *********** Step 2 : Open synthesized design and run report_clock_networks and add primary clock constraints and run report_clock_networks again ***********

proc addPriConstr {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName

set synth 0 

# Open the synthesized design
synthesisRun $synth

report_clock_networks -name {network_1}

set projName.srcs {append $projName .srcs}
set_property target_constrs_file C:/training/$tcName/$demoOrLab/$platform/$language/$projName.srcs/constrs_1/imports/$language/uart_led.xdc [current_fileset -constrset]

# Adding the Primary Clock Constraints for both 7 series and Ultra-Scale board

if {$platform == "KCU105"} {
	create_clock -period 8 -name clk_pin_p -waveform {0.000 1.667} [get_ports clk_pin_p]

} elseif {$platform == "KC705"} {
	create_clock -period 5.000 -name clk_pin_p -waveform {0.000 2.500} [get_ports clk_pin_p]

}
save_constraints

# Running the report_clock_networks
refresh_design
report_clock_networks -name {network_1}
report_clock_interaction -delay_type min_max -significant_digits 3 -name timing_1
check_timing -help

# Running check_timing 
check_timing -verbose

# Running report_timing_summary
report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
close_design
}

 
 ## *********** Step 3 : Implementing the design and run report_timing_summary ***********

proc genReport {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName

set impl 1 

# Implementing the design
implementationRun $impl

# Running report_timing_summary and view different sections of the report
report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
}


 ## *********** Step 4 : Adding the IO constraints and Implementing the design and run report_timing_summary again ***********

proc addIOConstr {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName

# Adding the Constraints for both 7 series and Ultra-Scale board

if {$platform == "KCU105"} {
	set_input_delay -clock [get_clocks clk_pin_p] 1.500 [get_ports {rst_pin rxd_pin btn_pin}]
	set_input_delay -clock [get_clocks clk_pin_p] -min 1.00 [get_ports {rst_pin rxd_pin btn_pin}]
	set_output_delay -clock [get_clocks clk_pin_p] 0.500 [get_ports led_pins*]
	set_output_delay -clock [get_clocks clk_pin_p] -min -0.500 [get_ports led_pins*]

} elseif {$platform == "KC705"} {

	set_input_delay -clock [get_clocks clk_pin_p] 1.000 [get_ports {rst_pin rxd_pin btn_pin}]
	set_input_delay -clock [get_clocks clk_pin_p] -min 0.500 [get_ports {rst_pin rxd_pin btn_pin}]
	set_output_delay -clock [get_clocks clk_pin_p] 1.000 [get_ports led_pins*]
	set_output_delay -clock [get_clocks clk_pin_p] -min -0.500 [get_ports led_pins*]
}

save_constraints -force

set impl 1 

# Implementing the design again
implementationRun $impl

# Running check_timing
check_timing

# close_design
}

 ## ********** Running only the steps that are required with Make **************

proc make {stopAt} {

   puts "Running until the step $stopAt"
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { openProject }
      step2  { make step1; addPriConstr }
      step3  { make step2; genReport }
      step4  { make step3; addIOConstr }
	  all    { make step4 }
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}
