###########################################################################
## HDL Instantiation Flow Completer Script
###########################################################################

# load the standard helper file
source C:/training/completer_helper_script/completer_helper.tcl

# project constants
set verbose 	1
set tcName 		phys_opt
set demoOrLab 	completed
set projName 	wave_gen

##########################################################
## Step 1: Opening the project and open implemented design 
##########################################################
proc openProject {} {
 variable platform
 variable tcName
 variable demoOrLab 
 variable projName 
 set projName.xpr {append $projName .xpr}

 # Add the platform and language combination that you want 
 set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
 if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
   }

 # Open a project
 open_project C:/training/$tcName/$demoOrLab/$platform/$projName.xpr
 
 #open Implemented design
 open_run impl_1
}

##########################################################
## Step 2: Analyzing Timing Critical Paths
##########################################################
proc criticalPaths {} {
   variable platform
  #Generate the timing summary report
   report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
}  
   
##########################################################
## Step 3: Implementing with phys_opt
##########################################################
proc implPhyOpt {} {
   variable platform
    
  # Create a new implementation run with physical optimization enabled              
  create_run impl_2 -parent_run synth_1 -flow {Vivado Implementation 2018}
  current_run [get_runs impl_2]
  set_property STEPS.PHYS_OPT_DESIGN.IS_ENABLED true [get_runs impl_2]
  set_property STEPS.POST_ROUTE_PHYS_OPT_DESIGN.IS_ENABLED true [get_runs impl_2]
  
  #Implementing the design with new run impl_2
  launch_runs impl_2 -jobs 4
  wait_on_run impl_2
  open_run impl_2
  
  #Analyzing the path that was failing previously
  if {$platform == "KCU105"} {
  report_timing -from [get_pins {clkx_nsamp_i0/bus_dst_reg[2]/C}] -to [get_pins {samp_gen_i0/samp_cnt_reg[3]/R}] -delay_type min_max -sort_by group -input_pins -name timing_1
  } elseif {$platform == "KC7xx"} {
  report_timing -from [get_pins {clkx_nsamp_i0/bus_dst_reg[5]/C}] -to [get_pins {samp_gen_i0/speed_cnt_reg[0]/CE}] -delay_type min_max -sort_by group -input_pins -name timing_1
  }
  # Review the implementation log to understand the physical optimization techniques performed
}

##########################################################
# Running through the steps that are required, with make
##########################################################
proc make {stopAt} {
   puts "Running until the step $stopAt"
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { openProject }
      step2  { make step1; criticalPaths }
      step3  { make step2; implPhyOpt }
      all    { make step3 }
      
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}
